package com.amity.socialcloud.sdk.video.data.stream

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamEntity
import com.amity.socialcloud.sdk.model.video.stream.AmityStream

internal class StreamModelMapper : ModelMapper<EkoStreamEntity, AmityStream>() {

    override fun map(entity: EkoStreamEntity): AmityStream {
        return with(entity) {
            AmityStream(
                streamId = streamId,
                moderationId = moderationId,
                status = AmityStream.Status.enumOf(status),
                title = title,
                description = description,
                resolution = resolution,
                watcherData = watcherData,
                broadcasterData = broadcasterData,
                recordings = recordings,
                thumbnailId = thumbnailFileId,
                userId = userId ?: "",
                metadata = metadata,
                isDeleted = isDeleted,
                referenceId = referenceId,
                referenceType = referenceType,
                targetId = targetId,
                targetType = targetType,
                postId = postId,
                channelId = channelId,
                channelEnabled = channelEnabled,
                isParent = isParent ?: true,
                parentStreamId = parentStreamId,
                childStreamIds = childStreamIds ?: emptyList(),
                childStreams = emptyList(),
                createdAt = createdAt,
                updatedAt = updatedAt
            )
        }
    }
}