package com.amity.socialcloud.sdk.video.data.stream

import com.amity.socialcloud.sdk.dto.video.EkoStreamListDto
import com.amity.socialcloud.sdk.dto.video.EkoStreamQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.CreateStreamRequest
import com.ekoapp.ekosdk.internal.api.socket.request.EditStreamRequest
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface StreamApi {

    @POST("api/v3/video-streaming")
    fun createVideoStreaming(
        @Body request: CreateStreamRequest
    ): Single<EkoStreamListDto>

    @PUT("api/v3/video-streaming")
    fun editVideoStreaming(
        @Body request: EditStreamRequest
    ): Single<EkoStreamListDto>

    @DELETE("api/v3/video-streaming/{streamId}/streaming-url")
    fun disposeVideoStreaming(
        @Path("streamId") streamId: String
    ): Single<EkoStreamListDto>

    @GET("api/v3/video-streaming/{streamId}")
    fun getVideoStreaming(
        @Path("streamId") streamId: String
    ): Single<EkoStreamListDto>

    @GET("api/v3/video-streaming/")
    fun queryVideoStreaming(
        @Query("isLive") isLive: Boolean? = null,
        @Query("statuses[]") statuses: List<String>? = null,
        @Query("userPublicIds[]") userPublicIds: List<String>? = null,
        @Query("sortBy") sortBy: String? = null,
        @Query("isDeleted") isDeleted: Boolean? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<EkoStreamQueryDto>
}