package com.amity.socialcloud.sdk.dto.core.ad

import com.amity.socialcloud.sdk.entity.core.ad.AdvertiserEntity
import org.joda.time.DateTime

class AdvertiserDto {
    var advertiserId: String? = null
    var name: String? = null
    var companyName: String? = null
    var avatarFileId: String? = null
    var createdAt: DateTime? =  null
    var updatedAt: DateTime? =  null
}

fun AdvertiserDto.toEntity(): AdvertiserEntity {
    return AdvertiserEntity(
        advertiserId = advertiserId ?: "",
        name = name ?: "",
        companyName = companyName ?: "",
        avatarFileId = avatarFileId,
    ).apply {
        createdAt = createdAt
        updatedAt = updatedAt
    }
}