package com.amity.socialcloud.sdk.core

import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto
import com.ekoapp.ekosdk.internal.api.dto.MarkedMessageDto
import com.ekoapp.ekosdk.internal.api.dto.SubChannelListDto

sealed class MarkerEvent {
	sealed class NetworkConnection: MarkerEvent() {
		object Connected : NetworkConnection()
		object Disconnected: NetworkConnection()
	}
	class NewMessage(val message: EkoMessageDto): MarkerEvent()
	open class MarkerUpdated(val event: String): MarkerEvent()
	class MarkedMessage(val dto: MarkedMessageDto): MarkerEvent()
	class SubChannelCreated(val eventName: String, val dto: SubChannelListDto): MarkerUpdated(eventName)
	class SubChannelDeleted(val eventName: String, val dto: SubChannelListDto): MarkerUpdated(eventName)
	
	open class Channel(open val eventName: String, open val dto: ChannelEventDto): MarkerUpdated(eventName)
	class ChannelLeft(override val eventName: String, override val dto: ChannelEventDto): Channel(eventName, dto)
	class ChannelBan(override val eventName: String, override val dto: ChannelEventDto): Channel(eventName, dto)
	class ChannelDeleted(override val eventName: String, override val dto: ChannelEventDto): Channel(eventName, dto)
}