package com.ekoapp.ekosdk.internal.api.dto

import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import com.google.gson.annotations.SerializedName
import org.joda.time.DateTime

data class EkoChannelDto(
	@SerializedName("channelId")
	val channelId: String,

	@SerializedName("_id")
	val mid: String? = null,

	@SerializedName("path")
	val path: String? = null,

	@SerializedName("type")
	val type: String? = null,

	@SerializedName("displayName")
	val displayName: String? = null,

	@SerializedName("metadata")
	private val metadata: JsonElement? = null,

	@SerializedName("messageCount")
	val messageCount: Int? = null,

	@SerializedName("isRateLimited")
	val isRateLimited:Boolean? = null,

	@SerializedName("isMuted")
	val isMuted: Boolean? = null,

	@SerializedName("lastActivity")
	val lastActivity: DateTime,

	@SerializedName("memberCount")
	val memberCount: Int? = null,

	@SerializedName("tags")
	val tags: AmityTags? = null,

	@SerializedName("avatarFileId")
	val avatarFileId: String? = null,

	@SerializedName("moderatorMemberCount")
	val moderatorMemberCount: Int,

	@SerializedName("isDeleted")
	val deleted: Boolean? = null,

	@SerializedName("messagePreviewId")
	val messagePreviewId: String? = null,

	@SerializedName("isPublic")
	val isPublic: Boolean? = null,

	@SerializedName("attachedTo")
	val attachedTo: EkoChannelAttachedToDto? = null,

) : EkoObjectDto() {

	fun getMetadata(): JsonObject? {
		return if (metadata != null && metadata.isJsonObject) {
			metadata.asJsonObject
		} else null
	}
}