package com.amity.socialcloud.sdk.video.domain.stream

import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.video.data.stream.StreamRepository
import io.reactivex.rxjava3.core.Single

internal class EditStreamUseCase {

    fun execute(
        streamId: String,
        channelEnabled: Boolean
    ): Single<AmityStream> {
        return StreamRepository().editStream(
            streamId = streamId,
            channelEnabled = channelEnabled,
        ).flatMap {
            GetStreamUseCase().execute(it).firstOrError()
        }
    }
}