package com.amity.socialcloud.sdk.social.domain.post

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class SemanticSearchPostUseCase {

    fun execute(
        query: String,
        targetType: AmityPost.TargetType?,
        targetId: String?,
        matchingOnlyParentPost: Boolean,
        postTypes: List<AmityPost.DataType>,
    ): Flowable<PagingData<AmityPost>> {
        return PostRepository().searchPosts(
            query = query,
            targetId = targetId,
            targetType = targetType?.apiKey,
            matchingOnlyParentPosts = matchingOnlyParentPost,
            postTypes = postTypes
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { post ->
                PostComposerUseCase().execute(post)
            }
        }
    }

}