/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Insert;
import com.ekoapp.ekosdk.RoleEkoObject;
import com.ekoapp.ekosdk.internal.data.model.EkoRoleObject;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class EkoRoleDao<EntityType extends EkoRoleObject> {
    static <RoleObject extends RoleEkoObject, RoleFactoryObject extends EkoRoleObject> void update(List<RoleObject> ekoObjects, EkoRoleDao<RoleFactoryObject> dao, EkoRoleObject.EkoRoleFactory<RoleFactoryObject> factory2) {
        for (RoleEkoObject ekoObject : ekoObjects) {
            EkoRoleDao.update(ekoObject, dao, factory2);
        }
    }

    static <RoleFactoryObject extends EkoRoleObject> void update(RoleEkoObject ekoObject, EkoRoleDao<RoleFactoryObject> dao, EkoRoleObject.EkoRoleFactory<RoleFactoryObject> factory2) {
        Object[] roles = ekoObject.getRoles().toArray(new String[0]);
        ImmutableList list2 = FluentIterable.from((Object[])roles).transform(role -> factory2.create(ekoObject.getReferenceRoleId(), ekoObject.getUserId(), (String)role)).toList();
        dao.insert((List<RoleFactoryObject>)list2);
        dao.retainAll(ekoObject.getReferenceRoleId(), ekoObject.getUserId(), (String[])roles);
    }

    @Insert(onConflict=1)
    abstract void insert(List<EntityType> var1);

    abstract void retainAll(String var1, String var2, String[] var3);
}

