package com.amity.socialcloud.sdk.core.domain.reaction

import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import com.amity.socialcloud.sdk.model.core.reaction.live.AmityLiveReaction
import io.reactivex.rxjava3.core.Completable

class SyncLiveReactionsUseCase {

    fun execute(
        liveStreamId: String,
        reactions: List<AmityLiveReaction>
    ) : Completable {
        return ReactionRepository().addLiveReactions(
            liveStreamId = liveStreamId,
            reactions = reactions,
        )
    }

}