package com.amity.socialcloud.sdk.api.social.storytarget


enum class AmityStoryTargetQueryOption(val apiKey: String) {

    UNSEEN("unseen"),
    SEEN("seen"),
    ALL("all"),
    SMART("smart");

    companion object {
        fun enumOf(apiKey: String): AmityStoryTargetQueryOption {
            return when (apiKey) {
                UNSEEN.apiKey -> UNSEEN
                SEEN.apiKey -> SEEN
                ALL.apiKey -> ALL
                else -> SMART
            }
        }
    }

}