package com.amity.socialcloud.sdk.api.social.member


import com.amity.socialcloud.sdk.api.social.member.query.AmityCommunityMembershipQuery
import com.amity.socialcloud.sdk.api.social.member.search.AmityCommunityMemberSearch
import com.amity.socialcloud.sdk.social.domain.community.participation.AddUsersCommunityParticipationUseCase
import com.amity.socialcloud.sdk.social.domain.community.participation.RemoveUsersCommunityParticipationUseCase
import io.reactivex.rxjava3.core.Completable

class AmityCommunityParticipation internal constructor(private val communityId: String) {
    
    /* begin_public_function
	  id: community.membership.query
	  api_style: live_collection
	*/
    /**
     * Initiates a function chain to query for community members.
     * @return new instance of AmityCommunityCreator.Builder.
     */
    fun getMembers(): AmityCommunityMembershipQuery.Builder {
        return AmityCommunityMembershipQuery.Builder(communityId)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: community.membership.search
	  api_style: live_collection
	*/
    /**
     * Initiates a function chain to search for community members.
     * @param [keyword] value to search by member's displayName
     * @return new instance of AmityCommunityCreator.Builder.
     */
    fun searchMembers(keyword: String): AmityCommunityMemberSearch.Builder {
        return AmityCommunityMemberSearch.Builder(communityId, keyword)
    }
    /* end_public_function */

    /* begin_public_function
     id: community.membership.add_members
    */
    /**
     * add members to a community
     * @param [userIds] a list of userId
     * @return Async completion as Completable
     */
    fun addMembers(userIds: List<String>): Completable {
        return AddUsersCommunityParticipationUseCase().execute(communityId, userIds)
    }
    /* end_public_function */

    /* begin_public_function
	  id: community.membership.remove_member
	*/
    /**
     * remove members from a community
     * @param [userIds] a list of userId
     * @return Async completion as Completable
     */
    fun removeMembers(userIds: List<String>): Completable {
        return RemoveUsersCommunityParticipationUseCase().execute(communityId, userIds)
    }
    /* end_public_function */

}