package com.ekoapp.ekosdk.internal.api.http.request

import com.ekoapp.ekosdk.internal.api.http.request.StreamSession
import com.ekoapp.ekosdk.internal.api.http.request.StreamSessionRequest
import com.google.gson.annotations.SerializedName

class StreamSessionRequest {
	@SerializedName("signature")
	private var signature: String? = null
	
	@SerializedName("nonceStr")
	private var nonceStr: String? = null
	
	@SerializedName("timestamp")
	private var timestamp: String? = null
	
	@SerializedName("streams")
	private var streams: List<StreamSession>? = null
	
	companion object {
		fun create(signature: String?, nonceStr: String?, timestamp: String?,
		           streams: List<StreamSession>?): StreamSessionRequest {
			val request = StreamSessionRequest()
			request.signature = signature
			request.nonceStr = nonceStr
			request.timestamp = timestamp
			request.streams = streams
			return request
		}
	}
}