package com.ekoapp.ekosdk.internal.api.dto;

import com.ekoapp.ekosdk.internal.data.model.EkoChannelMembershipQueryToken;
import com.google.gson.annotations.SerializedName;

import java.util.Collections;
import java.util.List;

public class ChannelMembershipQueryDto {

    @SerializedName("channels")
    private List<EkoChannelDto> channelDtoList = Collections.emptyList();

    @SerializedName("channelUsers")
    private List<EkoChannelMembershipDto> channelMembershipDtoList = Collections.emptyList();

    @SerializedName("users")
    List<EkoUserDto> users = Collections.emptyList();

    @SerializedName("files")
    List<EkoFileDto> files = Collections.emptyList();

    @SerializedName("paging")
    EkoChannelMembershipQueryToken token = new EkoChannelMembershipQueryToken();

    public List<EkoChannelDto> getChannelDtoList() {
        return channelDtoList;
    }

    public List<EkoChannelMembershipDto> getChannelMembershipDtoList() {
        return channelMembershipDtoList;
    }

    public List<EkoUserDto> getUsers() {
        return users;
    }

    public List<EkoFileDto> getFiles() {
        return files;
    }

    public EkoChannelMembershipQueryToken getToken() {
        return token;
    }

}