package com.amity.socialcloud.sdk.social.domain.post.create

import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostGetUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PostCreateUseCase
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single


internal class TextPostCreateUseCase : PostCreateUseCase {

    fun execute(
        targetType: String,
        targetId: String,
        text: String,
        title: String?,
        metadata: JsonObject?,
        mentionUserIds: List<String>?
    ): Single<AmityPost> {
        return PostRepository().createPostV4(
            targetType = targetType,
            targetId = targetId,
            data = composeData(text, title),
            dataType = null,
            attachments = null,
            metadata = metadata,
            mentionees = mapMentionees(mentionUserIds)
        ).flatMap {
            val post = PostGetUseCase().execute(it)
            if (post != null) {
                Single.just(post)
            } else {
                Single.error(AmityException.create("Post not found", null, AmityError.ITEM_NOT_FOUND))
            }
        }
    }

    private fun composeData(text: String, title: String?): JsonObject {
        return JsonObject().apply {
            addProperty("text", text)
            title?.takeIf { it.isNotBlank() }?.let {
                addProperty("title", it)
            }
        }
    }
}