package com.amity.socialcloud.sdk.model.chat.settings

import com.ekoapp.ekosdk.internal.api.dto.MessagePreviewSettingDto

enum class AmityMessagePreviewSetting {
	NO_MESSAGE_PREVIEW, MESSAGE_PREVIEW_INCLUDE_DELETED, MESSAGE_PREVIEW_NOT_INCLUDE_DELETED;
	
	companion object {
		val DEFAULT = NO_MESSAGE_PREVIEW
		fun fromString(value: String): AmityMessagePreviewSetting {
			return when (value) {
				"NO_MESSAGE_PREVIEW" -> return NO_MESSAGE_PREVIEW
				"MESSAGE_PREVIEW_INCLUDE_DELETED" -> return MESSAGE_PREVIEW_INCLUDE_DELETED
				"MESSAGE_PREVIEW_NOT_INCLUDE_DELETED" -> return MESSAGE_PREVIEW_NOT_INCLUDE_DELETED
				else -> DEFAULT
			}
		}
		
		fun fromMessagePreviewSettingDto(setting: MessagePreviewSettingDto): AmityMessagePreviewSetting {
			return when {
				setting.enabled && setting.isIncludeDeleted -> MESSAGE_PREVIEW_INCLUDE_DELETED
				setting.enabled && !setting.isIncludeDeleted -> MESSAGE_PREVIEW_NOT_INCLUDE_DELETED
				!setting.enabled -> NO_MESSAGE_PREVIEW
				else -> DEFAULT
			}
		}
	}
}