package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.log.AmityLog
import com.amity.socialcloud.sdk.social.data.post.PostEventPersister
import com.amity.socialcloud.sdk.social.data.post.PostLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass

internal abstract class PostEventListener: MqttEventListener<EkoPostQueryDto>() {

    override val type: KClass<EkoPostQueryDto>
        get() = EkoPostQueryDto::class

    override fun processEvent(dto: EkoPostQueryDto) {
        PostEventPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError {
                AmityLog.e(it)
            }
            .subscribe()
    }

    override fun shouldProcessEvent(dto: EkoPostQueryDto): Boolean {
        var shouldProcessEvent = false
        val postId = dto.posts?.first()?.postId
        postId?.let {
            shouldProcessEvent = PostLocalDataStore().hasInLocal(it)
        }
        return shouldProcessEvent
    }

}