package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository
import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.amity.socialcloud.sdk.log.AmityLog
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto
import io.reactivex.rxjava3.schedulers.Schedulers

internal class ChannelBanned : ChannelEventListener() {

    override fun getEventName(): String {
        return "channel.banned"
    }

    override fun processEvent(dto: ChannelEventDto) {
        super.processEvent(dto)
        dto.channelMembershipDtoList.forEach {
            ChannelMembershipRepository().handleMembershipBanned(
                channelId = it.channelId,
                userId = it.userId
            )
                .subscribeOn(Schedulers.io())
                .doOnError { AmityLog.e(it) }
                .subscribe()
        }
        
        if (isActiveUserRemovedEvent(dto)) {
            MarkerEventBus.publish(MarkerEvent.ChannelBan(getEventName(), dto))
        }
    }

}