package com.amity.socialcloud.sdk.core.data.user.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSearchMatchType
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSortOption
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface UserPagingDao : DynamicQueryStreamPagingDao<UserEntity> {

    @RawQuery(observedEntities = [UserEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, UserEntity>

    fun getUserPagingSource(
        keyword: String?,
        matchType: AmityUserSearchMatchType?,
        sortBy: AmityUserSortOption
    ): PagingSource<Int, UserEntity> {
        val sortColumn = when(sortBy) {
            AmityUserSortOption.DISPLAYNAME -> null
            AmityUserSortOption.FIRST_CREATED -> "createdAt"
            AmityUserSortOption.LAST_CREATED -> "createdAt"
        }
        val order = when(sortBy) {
            AmityUserSortOption.DISPLAYNAME -> AmityPagingDao.Order.ASC
            AmityUserSortOption.FIRST_CREATED -> AmityPagingDao.Order.ASC
            AmityUserSortOption.LAST_CREATED -> AmityPagingDao.Order.DESC
        }
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "user",
                primaryKeyColumnName = "userId",
                nonce = AmityNonce.USER_LIST,
                sortColumn = sortColumn,
                order = order,
                dynamicQueryStreamKeyCreator = UserKeyCreator(
                    keyword = keyword,
                    matchType = matchType?.value,
                    sortBy = sortBy,
                )
            )
        )
    }

}