package com.amity.socialcloud.sdk.chat.domain.channel.member

import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository
import com.amity.socialcloud.sdk.chat.domain.channel.member.ChannelMemberComposerUseCase
import com.amity.socialcloud.sdk.model.chat.member.AmityChannelMember
import io.reactivex.rxjava3.core.Flowable

internal class GetChannelMembersUseCase {

    fun execute(channelId: String) : Flowable<List<AmityChannelMember>> {
        return ChannelMembershipRepository().observeChannelMembers(channelId)
            .map { members ->
                members.map {
                    ChannelMemberComposerUseCase().execute(it)
                }
            }
    }

}