package com.amity.socialcloud.sdk.chat.data.marker.sync

import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.MarkerSyncDto
import io.reactivex.rxjava3.core.Single
import org.joda.time.DateTime

internal class MarkerSyncRemoteDataStore {

    fun syncMarkers(deviceLastSyncAt: DateTime?): Single<MarkerSyncDto> {
        val request = MarkerSyncRequest(deviceLastSyncAt)
        return AmityHttpClient.get(MarkerSyncApi::class).flatMap {
            it.syncMarkers(request)
        }
    }

}