package com.amity.socialcloud.sdk.api.social.post.create.datatype

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.model.core.file.AmityFile
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.google.gson.JsonObject

class AmityFilePostCreator private constructor(
    targetType: String,
    targetId: String,
    private val text: String,
    private val files: List<AmityFile>,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?
) : AmityPostCreator(targetType, targetId, metadata, mentionees) {

    class Builder {
        private var targetType = ""
        private var targetId = ""
        private var text = ""
        private var files: List<AmityFile> = mutableListOf()
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null

        internal fun targetType(targetType: String): Builder {
            this.targetType = targetType
            return this
        }

        internal fun targetId(targetId: String): Builder {
            this.targetId = targetId
            return this
        }

        /**
         * @param [text] to add text to the post
         * @return the same instance of AmityFilePostCreator.Builder
         */
        fun text(text: String): Builder {
            this.text = text
            return this
        }

        internal fun files(vararg files: AmityFile): Builder {
            this.files = files.asList()
            return this
        }

        /**
         * @param [metadata] to add metadata to the post
         * @return the same instance of AmityFilePostCreator.Builder
         */
        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        /**
         * @param [userIds] list of userId of users to be mentioned by this post
         * @return the same instance of AmityFilePostCreator.Builder
         */
        fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees =
                listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        /**
         * Instantiates AmityFilePostCreator with built params.
         * @return new instance of AmityFilePostCreator.
         */
        fun build(): AmityFilePostCreator {
            return AmityFilePostCreator(targetType, targetId, text, files, metadata, mentionees)
        }
    }

    override fun getPostDataType(): AmityPost.DataType {
        return AmityPost.DataType.FILE
    }

    override fun getFiles(): List<AmityFile> {
        return files
    }

    override fun getText(): String {
        return text
    }
}