package com.amity.socialcloud.sdk.social.data.poll

import com.amity.socialcloud.sdk.model.social.poll.AmityPoll
import com.amity.socialcloud.sdk.model.social.poll.AmityPollAnswer
import com.ekoapp.ekosdk.EkoObjectRepository
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single

internal class PollRepository : EkoObjectRepository() {

    fun createPoll(
        question: String,
        answers: List<AmityPollAnswer.Data>,
        answerType: String,
        closedIn: Long?,
        title: String?
    ): Single<String> {
        return PollRemoteDataStore().createPoll(question, answers, answerType, closedIn, title)
            .flatMap { dto ->
                PollQueryPersister().persist(dto)
                    .andThen(dto.polls[0].pollId?.let { Single.just(it) } ?: Single.never())
            }
    }

    fun observePoll(pollId: String): Flowable<AmityPoll> {
        return PollLocalDataStore().observePoll(pollId)
            .map { PollModelMapper().map(it) }
    }

    fun closePoll(pollId: String): Completable {
        return PollRemoteDataStore().closePoll(pollId)
            .flatMapCompletable { PollQueryPersister().persist(it) }
    }

    fun deletePoll(pollId: String): Completable {
        return PollRemoteDataStore().deletePoll(pollId)
            .flatMapCompletable {
                when (it.isSuccess) {
                    true -> PollLocalDataStore().deletePoll(pollId)
                    else -> Completable.complete()
                }
            }
    }

    fun vote(pollId: String, answerIds: List<String>): Completable {
        return PollRemoteDataStore().vote(pollId, answerIds)
            .flatMapCompletable { PollQueryPersister().persist(it) }
    }

    fun unvote(pollId: String): Completable {
        return PollRemoteDataStore().vote(pollId, emptyList())
            .flatMapCompletable { PollQueryPersister().persist(it) }
    }

}