package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class SearchPostsByHashtagUseCase {

    fun execute(
        hashtags: List<String>,
        dataTypes: List<AmityPost.DataType>,
    ): Flowable<PagingData<AmityPost>> {
        return PostRepository().searchPosts(
            hashtags = hashtags,
            dataTypes = dataTypes,
        )
                .map { pagingData ->
                    pagingData.map(Executors.newSingleThreadExecutor()) { post ->
                        PostComposerUseCase().execute(post)
                    }
                }
    }
}