package com.amity.socialcloud.sdk.model.core.file

import android.net.Uri
import android.os.Parcelable


abstract class AmityFileInfo(internal val rawFile: AmityRawFile) : Parcelable {

    fun getFileId(): String {
        return rawFile.getFileId()
    }
    
    fun getUrl(): String? {
        return rawFile.getUrl()
    }

    fun getFileExtension(): String? {
        return rawFile.getFileExtension()
    }

    fun getFileName(): String {
        return rawFile.getFileName()
    }

    fun getMimeType(): String {
        return rawFile.getMimeType()
    }

    fun getFileSize(): Long {
        return rawFile.getFileSize()
    }

    @Deprecated("Please use getUri() instead")
    fun getFilePath(): String? {
        return rawFile.getFilePath()?.let(Uri::parse)?.path
    }

    fun getUri(): Uri? {
        return rawFile.getFilePath()?.let(Uri::parse)
    }

    fun getAccessType(): AmityFileAccessType {
        return rawFile.getAccessType()
    }
}