package com.amity.socialcloud.sdk.chat.data.message

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap
import com.ekoapp.ekosdk.internal.EkoMessageEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto
import com.ekoapp.ekosdk.internal.api.dto.EkoPiiDto
import com.ekoapp.ekosdk.internal.util.PIIUtils

internal class MessageEntityMapper : EntityMapper<EkoMessageDto, EkoMessageEntity>() {

    override fun map(list: List<EkoMessageDto>): List<EkoMessageEntity> {
        return list.map { map(it) }
    }

    fun map(dto: EkoMessageDto): EkoMessageEntity {
        return EkoMessageEntity().apply {
            messageId = dto.getMessageId()
            uniqueId = dto.referenceId
            subChannelId = dto.subChannelId
            channelId = dto.getChannelId()
            userId = dto.getUserId()
            parentId = dto.getParentId()
            type = dto.getType()
            setChannelSegment(dto.segment)
            childrenNumber = dto.getChildrenNumber()
            data = dto.getData()
            isDeleted = dto.isDeleted()
            flagCount = dto.getFlagCount()
            setTags(dto.getTags())
            reactionCount = dto.getReactionCount()
            reactions = if (dto.getReactions() == null) AmityReactionMap() else dto.getReactions()
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
            editedAt = dto.editedAt ?: dto.createdAt
            metadata = dto.getMetadata()
            if (dto.getMentionees() != null) {
                mentionees = dto.getMentionees().map { EkoMentioneesDto(type = it.type, userIds = it.userPublicIds) }
            }
            dto.getPii()?.let { piiDtos ->
                pii = PIIUtils.convertDtosToJsonArray(piiDtos)
            }
            path = dto.path
        }
    }

}