package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.ekoapp.ekosdk.internal.api.dto.EkoFollowEventDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoFollowEventPersister
import kotlin.reflect.KClass


internal abstract class FollowEventListener : MqttEventListener<EkoFollowEventDto>() {

    override val type: KClass<EkoFollowEventDto>
        get() = EkoFollowEventDto::class

    override fun processEvent(dto: EkoFollowEventDto) {
        EkoFollowEventPersister.persist(dto)
    }

    override fun shouldProcessEvent(dto: EkoFollowEventDto): Boolean {
        return true
    }
}