/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.comment;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentDataTypeFilter;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentSortOption;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget;
import com.amity.socialcloud.sdk.model.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.data.comment.CommentLocalDataStore;
import com.amity.socialcloud.sdk.social.data.comment.CommentModelMapper;
import com.amity.socialcloud.sdk.social.data.comment.CommentQueryPersister;
import com.amity.socialcloud.sdk.social.data.comment.CommentRemoteDataStore;
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository;
import com.amity.socialcloud.sdk.social.data.post.PostLocalDataStore;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentAndUserListDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.api.socket.request.CommentQueryRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.FlagContentRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.repository.comment.CommentLoadResult;
import com.ekoapp.ekosdk.internal.repository.comment.CommentMediator;
import com.google.common.base.Objects;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.amity.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jl\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000eJh\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bJB\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000eJ\u0016\u0010\u001d\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0007J \u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000e0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ(\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000e0\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010&\u001a\u00020'JU\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050)0\"2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010+\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020'2\b\u0010,\u001a\u0004\u0018\u00010-\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u000200H\u0002J$\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u001bJE\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\"2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010+\u001a\u0004\u0018\u00010\u001b2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000200\u00a2\u0006\u0002\u00105J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J$\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J \u00108\u001a\n\u0012\u0004\u0012\u000209\u0018\u00010\u000e2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000eH\u0002J \u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\u0007H\u0002J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\n\u001a\u00020\u0007JE\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010+\u001a\u0004\u0018\u00010\u001b2\u0006\u0010B\u001a\u00020\u0007\u00a2\u0006\u0002\u0010CJM\u0010D\u001a\b\u0012\u0004\u0012\u00020A0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010+\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010E\u001a\u000200\u00a2\u0006\u0002\u0010FJ\u000e\u0010G\u001a\u00020;2\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010H\u001a\u00020;2\u0006\u0010\n\u001a\u00020\u0007J\u0014\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00050\"2\u0006\u0010\n\u001a\u00020\u0007JF\u0010J\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000e0\"2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\b\u0010K\u001a\u0004\u0018\u00010\u0007J\u000e\u0010L\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0007J\u0018\u0010M\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u0007H\u0002\u00a8\u0006N"}, d2={"Lcom/amity/socialcloud/sdk/social/data/comment/CommentRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "createComment", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment;", "referenceType", "", "referenceId", "parentId", "commentId", "data", "Lcom/google/gson/JsonObject;", "dataTypes", "", "attachments", "Lcom/google/gson/JsonArray;", "metadata", "mentionees", "Lcom/amity/socialcloud/sdk/model/core/mention/AmityMentioneeTarget;", "createTempComment", "Lcom/ekoapp/ekosdk/internal/entity/CommentEntity;", "createTempFlag", "Lcom/ekoapp/ekosdk/internal/data/model/EkoCommentFlagEntity;", "deleteComment", "Lio/reactivex/rxjava3/core/Completable;", "hardDelete", "", "editComment", "flagComment", "reason", "Lcom/ekoapp/ekosdk/internal/api/socket/request/FlagContentRequest;", "getComment", "getCommentByIds", "Lio/reactivex/rxjava3/core/Flowable;", "commentIds", "getCommentCollection", "ids", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentSortOption;", "getCommentPagingData", "Landroidx/paging/PagingData;", "isFilterByParentId", "isDeleted", "dataTypeFilter", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentDataTypeFilter;", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentSortOption;Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentDataTypeFilter;)Lio/reactivex/rxjava3/core/Flowable;", "getDefaultPageSize", "", "getLatestComment", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "getLatestComments", "getLatestReplies", "getMentioneesDto", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoMentioneesDto;", "insertOrUpdate", "", "comment", "commentFlag", "syncState", "isFlaggedByMe", "loadComments", "Lcom/ekoapp/ekosdk/internal/repository/comment/CommentLoadResult;", "token", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Single;", "loadFirstPageComments", "limit", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentSortOption;I)Lio/reactivex/rxjava3/core/Single;", "markDeletedAfterCommentId", "markDeletedBeforeCommentId", "observeComment", "observeCommentAfter", "offsetCommentId", "unflagComment", "updateSyncState", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nCommentRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentRepository.kt\ncom/amity/socialcloud/sdk/social/data/comment/CommentRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,518:1\n1549#2:519\n1620#2,3:520\n*S KotlinDebug\n*F\n+ 1 CommentRepository.kt\ncom/amity/socialcloud/sdk/social/data/comment/CommentRepository\n*L\n492#1:519\n492#1:520,3\n*E\n"})
public final class CommentRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @Nullable
    public final AmityComment getComment(@NotNull String commentId) {
        AmityComment amityComment;
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        CommentEntity commentEntity = new CommentLocalDataStore().getComment(commentId);
        if (commentEntity != null) {
            CommentEntity it = commentEntity;
            boolean bl = false;
            amityComment = new CommentModelMapper().map(it);
        } else {
            amityComment = null;
        }
        return amityComment;
    }

    @NotNull
    public final Flowable<List<AmityComment>> getCommentByIds(@NotNull List<String> commentIds) {
        Intrinsics.checkNotNullParameter(commentIds, (String)"commentIds");
        Flowable flowable = new CommentRemoteDataStore().getCommentByIds(commentIds).flatMap((Function)getCommentByIds.1.INSTANCE).flatMapPublisher((Function)getCommentByIds.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommentRemoteDataStore()\u2026          }\n            }");
        return flowable;
    }

    @NotNull
    public final List<AmityComment> getLatestComments(@NotNull String referenceType, @NotNull String referenceId) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        return new CommentLocalDataStore().getLatestComments(referenceType, referenceId);
    }

    @NotNull
    public final List<AmityComment> getLatestReplies(@NotNull String referenceType, @NotNull String referenceId, @NotNull String parentId) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        return new CommentLocalDataStore().getLatestReplies(referenceType, referenceId, parentId);
    }

    @NotNull
    public final Flowable<AmityComment> observeComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Flowable flowable = new CommentLocalDataStore().observeComment(commentId).map((Function)observeComment.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommentLocalDataStore().\u2026r().map(it)\n            }");
        return flowable;
    }

    @NotNull
    public final Single<AmityComment> createComment(@NotNull String referenceType, @NotNull String referenceId, @Nullable String parentId, @Nullable String commentId, @Nullable JsonObject data, @NotNull List<String> dataTypes, @Nullable JsonArray attachments, @Nullable JsonObject metadata, @Nullable List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        CommentEntity localComment = this.createTempComment(referenceType, referenceId, parentId, commentId, data, dataTypes, attachments, metadata, mentionees);
        EkoCommentFlagEntity commentFlag = this.createTempFlag(localComment.getCommentId());
        Single single = Single.fromCallable(() -> CommentRepository.createComment$lambda$1(this, localComment, commentFlag)).flatMap(new Function(localComment, referenceType, referenceId, parentId, data, attachments, metadata, mentionees){
            final /* synthetic */ CommentEntity $localComment;
            final /* synthetic */ String $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $parentId;
            final /* synthetic */ JsonObject $data;
            final /* synthetic */ JsonArray $attachments;
            final /* synthetic */ JsonObject $metadata;
            final /* synthetic */ List<AmityMentioneeTarget> $mentionees;
            {
                this.$localComment = $localComment;
                this.$referenceType = $referenceType;
                this.$referenceId = $referenceId;
                this.$parentId = $parentId;
                this.$data = $data;
                this.$attachments = $attachments;
                this.$metadata = $metadata;
                this.$mentionees = $mentionees;
            }

            @NotNull
            public final SingleSource<? extends EkoCommentAndUserListDto> apply(@NotNull CommentEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CommentRemoteDataStore commentRemoteDataStore = new CommentRemoteDataStore();
                String string = this.$localComment.getCommentId();
                return (SingleSource)commentRemoteDataStore.createComment(this.$referenceType, this.$referenceId, this.$parentId, string, this.$data, this.$attachments, this.$metadata, this.$mentionees);
            }
        }).onErrorResumeNext(new Function(this, localComment){
            final /* synthetic */ CommentRepository this$0;
            final /* synthetic */ CommentEntity $localComment;
            {
                this.this$0 = $receiver;
                this.$localComment = $localComment;
            }

            @NotNull
            public final SingleSource<? extends EkoCommentAndUserListDto> apply(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CommentRepository.access$updateSyncState(this.this$0, this.$localComment, AmityComment.State.FAILED.getStateName());
                return (SingleSource)Single.error((Throwable)it);
            }
        }).flatMap(new Function(this, localComment){
            final /* synthetic */ CommentRepository this$0;
            final /* synthetic */ CommentEntity $localComment;
            {
                this.this$0 = $receiver;
                this.$localComment = $localComment;
            }

            @NotNull
            public final SingleSource<? extends String> apply(@NotNull EkoCommentAndUserListDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CommentRepository.access$updateSyncState(this.this$0, this.$localComment, AmityComment.State.SYNCED.getStateName());
                return (SingleSource)new CommentQueryPersister().persist(it).andThen((SingleSource)Single.just((Object)it.getComments().get(0).getCommentId()));
            }
        }).flatMap(new Function(this){
            final /* synthetic */ CommentRepository this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final SingleSource<? extends AmityComment> apply(@NotNull String commentId) {
                SingleSource singleSource;
                Single single;
                Object object;
                Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
                AmityComment comment = this.this$0.getComment(commentId);
                Object object2 = comment;
                if (object2 != null && (object2 = ((AmityComment)object2).getReference()) != null) {
                    Object reference = object2;
                    boolean bl = false;
                    PostLocalDataStore postLocalDataStore = new PostLocalDataStore();
                    if (reference instanceof AmityComment.Reference.POST) {
                        postLocalDataStore.incrementCommentCount(((AmityComment.Reference.POST)reference).getPostId());
                        postLocalDataStore.notifyPost(((AmityComment.Reference.POST)reference).getPostId());
                    } else if (reference instanceof AmityComment.Reference.CONTENT) {
                        postLocalDataStore.incrementCommentCount(((AmityComment.Reference.CONTENT)reference).getContentId());
                        postLocalDataStore.notifyPost(((AmityComment.Reference.CONTENT)reference).getContentId());
                    }
                }
                if ((object = comment) != null && (object = ((AmityComment)object).getParentId()) != null) {
                    Object parentCommentId = object;
                    boolean bl = false;
                    CommentLocalDataStore commentLocalDataStore = new CommentLocalDataStore();
                    commentLocalDataStore.notifyParentComment((String)parentCommentId);
                }
                AmityComment amityComment = comment;
                if (amityComment != null) {
                    AmityComment it = amityComment;
                    boolean bl = false;
                    single = Single.just((Object)it);
                } else {
                    single = null;
                }
                if (single == null) {
                    Single single2 = Single.never();
                    Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"never()");
                    singleSource = (SingleSource)single2;
                } else {
                    singleSource = (SingleSource)single;
                }
                return singleSource;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fun createComment(\n     \u2026e.never()\n        }\n    }");
        return single;
    }

    @NotNull
    public final Single<AmityComment> editComment(@NotNull String commentId, @Nullable JsonObject data, @Nullable JsonArray attachments, @Nullable JsonObject metadata, @Nullable List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Single single = new CommentRemoteDataStore().updateComment(commentId, data, attachments, metadata, mentionees).flatMap((Function)editComment.1.INSTANCE).flatMap(new Function(this){
            final /* synthetic */ CommentRepository this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final SingleSource<? extends AmityComment> apply(@NotNull String commentId) {
                SingleSource singleSource;
                Single single;
                Object object;
                Object it;
                Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
                AmityComment comment = this.this$0.getComment(commentId);
                Object object2 = comment;
                if (object2 != null && (object2 = ((AmityComment)object2).getReference()) != null) {
                    it = object2;
                    boolean bl = false;
                    if (it instanceof AmityComment.Reference.POST) {
                        PostLocalDataStore postLocalDataStore = new PostLocalDataStore();
                        postLocalDataStore.notifyPost(((AmityComment.Reference.POST)it).getPostId());
                    }
                }
                if ((object = comment) != null && (object = ((AmityComment)object).getParentId()) != null) {
                    it = object;
                    boolean bl = false;
                    CommentLocalDataStore commentLocalDataStore = new CommentLocalDataStore();
                    commentLocalDataStore.notifyParentComment((String)it);
                }
                AmityComment amityComment = comment;
                if (amityComment != null) {
                    it = amityComment;
                    boolean bl = false;
                    single = Single.just((Object)it);
                } else {
                    single = null;
                }
                if (single == null) {
                    Single single2 = Single.never();
                    Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"never()");
                    singleSource = (SingleSource)single2;
                } else {
                    singleSource = (SingleSource)single;
                }
                return singleSource;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fun editComment(\n       \u2026ver()\n            }\n    }");
        return single;
    }

    @NotNull
    public final Completable deleteComment(@NotNull String commentId, boolean hardDelete) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Completable completable = new CommentLocalDataStore().observeComment(commentId).firstOrError().subscribeOn(Schedulers.io()).flatMapCompletable(new Function(commentId, hardDelete){
            final /* synthetic */ String $commentId;
            final /* synthetic */ boolean $hardDelete;
            {
                this.$commentId = $commentId;
                this.$hardDelete = $hardDelete;
            }

            @NotNull
            public final CompletableSource apply(@NotNull CommentEntity localComment) {
                Intrinsics.checkNotNullParameter((Object)localComment, (String)"localComment");
                return Intrinsics.areEqual((Object)localComment.getSyncState(), (Object)AmityComment.State.FAILED.getStateName()) ? (CompletableSource)new CommentLocalDataStore().hardDelete(localComment.getCommentId()) : (CompletableSource)new CommentRemoteDataStore().deleteComment(this.$commentId, this.$hardDelete).flatMapCompletable(new Function(this.$commentId, this.$hardDelete){
                    final /* synthetic */ String $commentId;
                    final /* synthetic */ boolean $hardDelete;
                    {
                        this.$commentId = $commentId;
                        this.$hardDelete = $hardDelete;
                    }

                    @NotNull
                    public final CompletableSource apply(@NotNull EkoDeletionDto it) {
                        CompletableSource completableSource;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (it.isSuccess()) {
                            Completable completable;
                            CommentLocalDataStore commentLocalDataStore = new CommentLocalDataStore();
                            CommentEntity commentEntity = new CommentLocalDataStore().getComment(this.$commentId);
                            if (commentEntity != null) {
                                if (Objects.equal((Object)commentEntity.getReferenceType(), (Object)"post")) {
                                    new PostLocalDataStore().decrementCommentCount(commentEntity.getReferenceId());
                                } else if (Objects.equal((Object)commentEntity.getReferenceType(), (Object)"content")) {
                                    new PostLocalDataStore().decrementCommentCount(commentEntity.getReferenceId());
                                }
                                completable = this.$hardDelete ? commentLocalDataStore.hardDelete(this.$commentId) : commentLocalDataStore.softDelete(this.$commentId);
                            } else {
                                Completable completable2 = Completable.complete();
                                completable = completable2;
                                Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n                      \u2026                        }");
                            }
                            completableSource = (CompletableSource)completable;
                        } else {
                            completableSource = (CompletableSource)Completable.complete();
                        }
                        return completableSource;
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"commentId: String, hardD\u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Flowable<PagingData<AmityComment>> getCommentPagingData(@NotNull String referenceId, @NotNull String referenceType, boolean isFilterByParentId, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull AmityCommentSortOption sortOption, @Nullable AmityCommentDataTypeFilter dataTypeFilter) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new CommentMediator(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption, dataTypeFilter), (Function0)new Function0<PagingSource<Integer, CommentEntity>>(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption, dataTypeFilter){
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $referenceType;
            final /* synthetic */ boolean $isFilterByParentId;
            final /* synthetic */ String $parentId;
            final /* synthetic */ Boolean $isDeleted;
            final /* synthetic */ AmityCommentSortOption $sortOption;
            final /* synthetic */ AmityCommentDataTypeFilter $dataTypeFilter;
            {
                this.$referenceId = $referenceId;
                this.$referenceType = $referenceType;
                this.$isFilterByParentId = $isFilterByParentId;
                this.$parentId = $parentId;
                this.$isDeleted = $isDeleted;
                this.$sortOption = $sortOption;
                this.$dataTypeFilter = $dataTypeFilter;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, CommentEntity> invoke() {
                return new CommentLocalDataStore().getCommentPagingSource(this.$referenceId, this.$referenceType, this.$isFilterByParentId, this.$parentId, this.$isDeleted, this.$sortOption, this.$dataTypeFilter);
            }
        }, (ModelMapper)new CommentModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Single<AmityComment> getLatestComment(@NotNull String referenceId, @NotNull String referenceType, boolean isFilterByParentId) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        CommentQueryRequest.CommentQueryRequestOptions options = new CommentQueryRequest.CommentQueryRequestOptions(null, null, null, null, 1, null, "pagination", null, 175, null);
        CommentQueryRequest commentQueryRequest = new CommentQueryRequest(referenceId, referenceType, isFilterByParentId, null, false, AmityCommentSortOption.LAST_CREATED.getApiKey(), options, null, 136, null);
        Single single = new CommentRemoteDataStore().queryComments(commentQueryRequest).flatMap((Function)getLatestComment.1.INSTANCE).flatMap((Function)getLatestComment.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"CommentRemoteDataStore()\u2026          }\n            }");
        return single;
    }

    @NotNull
    public final Flowable<List<AmityComment>> observeCommentAfter(@NotNull String referenceType, @NotNull String referenceId, @Nullable String parentId, boolean isFilterByParentId, @NotNull AmityCommentSortOption sortOption, @Nullable String offsetCommentId) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Flowable flowable = UserDatabase.get().commentDao().observeCommentAfter(referenceType, referenceId, parentId, isFilterByParentId, sortOption, offsetCommentId).map((Function)observeCommentAfter.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"get().commentDao().obser\u2026)\n            }\n        }");
        return flowable;
    }

    @NotNull
    public final Single<CommentLoadResult> loadComments(@NotNull String referenceId, @NotNull String referenceType, boolean isFilterByParentId, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull String token) {
        CommentQueryRequest.CommentQueryRequestOptions commentQueryRequestOptions;
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        CommentQueryRequest.CommentQueryRequestOptions $this$loadComments_u24lambda_u242 = commentQueryRequestOptions = new CommentQueryRequest.CommentQueryRequestOptions(null, null, null, null, null, null, null, null, 255, null);
        boolean bl = false;
        $this$loadComments_u24lambda_u242.setType("pagination");
        $this$loadComments_u24lambda_u242.setToken(token);
        CommentQueryRequest.CommentQueryRequestOptions options = commentQueryRequestOptions;
        CommentQueryRequest commentQueryRequest = new CommentQueryRequest(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, null, options, null, 160, null);
        Single single = new CommentRemoteDataStore().queryComments(commentQueryRequest).flatMap((Function)loadComments.1.INSTANCE).map((Function)loadComments.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"CommentRemoteDataStore()\u2026nNext, ids)\n            }");
        return single;
    }

    @NotNull
    public final Single<CommentLoadResult> loadFirstPageComments(@NotNull String referenceType, @NotNull String referenceId, boolean isFilterByParentId, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull AmityCommentSortOption sortOption, int limit) {
        CommentQueryRequest.CommentQueryRequestOptions commentQueryRequestOptions;
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        CommentQueryRequest.CommentQueryRequestOptions $this$loadFirstPageComments_u24lambda_u243 = commentQueryRequestOptions = new CommentQueryRequest.CommentQueryRequestOptions(null, null, null, null, null, null, null, null, 255, null);
        boolean bl = false;
        $this$loadFirstPageComments_u24lambda_u243.setSkip(0);
        $this$loadFirstPageComments_u24lambda_u243.setLimit(limit);
        $this$loadFirstPageComments_u24lambda_u243.setType("pagination");
        CommentQueryRequest.CommentQueryRequestOptions options = commentQueryRequestOptions;
        CommentQueryRequest commentQueryRequest = new CommentQueryRequest(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption.getApiKey(), options, null, 128, null);
        Single single = new CommentRemoteDataStore().queryComments(commentQueryRequest).flatMap((Function)loadFirstPageComments.1.INSTANCE).map((Function)loadFirstPageComments.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"CommentRemoteDataStore()\u2026token, ids)\n            }");
        return single;
    }

    public final void markDeletedAfterCommentId(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        new CommentLocalDataStore().markDeletedAfterCommentId(commentId);
    }

    public final void markDeletedBeforeCommentId(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        new CommentLocalDataStore().markDeletedBeforeCommentId(commentId);
    }

    @NotNull
    public final Flowable<List<AmityComment>> getCommentCollection(@NotNull List<String> ids, @NotNull AmityCommentSortOption sortOption) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Flowable flowable = UserDatabase.get().commentDao().getAllByIds(ids, sortOption).map((Function)getCommentCollection.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"get().commentDao().getAl\u2026commentList\n            }");
        return flowable;
    }

    @NotNull
    public final Completable flagComment(@NotNull String commentId, @NotNull FlagContentRequest reason) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Completable completable = new CommentRemoteDataStore().flagComment(commentId, reason).flatMapCompletable((Function)flagComment.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommentRemoteDataStore()\u2026persist(it)\n            }");
        return completable;
    }

    @NotNull
    public final Completable unflagComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Completable completable = new CommentRemoteDataStore().unflagComment(commentId).flatMapCompletable((Function)unflagComment.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommentRemoteDataStore()\u2026persist(it)\n            }");
        return completable;
    }

    @NotNull
    public final Single<JsonObject> isFlaggedByMe(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new CommentRemoteDataStore().isFlaggedByMe(commentId);
    }

    @NotNull
    public final Flowable<AmityComment> getLatestComment(@NotNull String referenceId, @NotNull String referenceType, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new CommentLocalDataStore().getLatestComment(referenceId, referenceType, parentId, isDeleted, dynamicQueryStreamKeyCreator, nonce).map((Function)getLatestComment.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommentLocalDataStore()\n\u2026r().map(it)\n            }");
        return flowable;
    }

    private final CommentEntity createTempComment(String referenceType, String referenceId, String parentId, String commentId, JsonObject data, List<String> dataTypes, JsonArray attachments, JsonObject metadata, List<AmityMentioneeTarget> mentionees) {
        CharSequence charSequence = commentId;
        String id = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ObjectId.Companion.get().toHexString() : commentId;
        DateTime now = new DateTime();
        String string = AmityCoreClient.INSTANCE.getUserId();
        String string2 = AmityComment.State.CREATED.getStateName();
        List list2 = this.getMentioneesDto(mentionees);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List list3 = list2;
        CommentEntity comment = new CommentEntity(id, null, referenceType, referenceId, string, parentId, null, null, dataTypes, data, attachments, metadata, 0, 0, null, 0, false, now, string2, 0, list3, null, null, null, 15331522, null);
        comment.setCreatedAt(now);
        comment.setUpdatedAt(now);
        return comment;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EkoMentioneesDto> getMentioneesDto(List<AmityMentioneeTarget> mentionees) {
        List list2;
        List<AmityMentioneeTarget> list3 = mentionees;
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AmityMentioneeTarget amityMentioneeTarget = (AmityMentioneeTarget)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new EkoMentioneesDto(it.getType(), it.getUserIds(), null, 4, null));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private final EkoCommentFlagEntity createTempFlag(String commentId) {
        EkoCommentFlagEntity commentFlag = new EkoCommentFlagEntity(commentId, null, null, 6, null);
        return commentFlag;
    }

    private final void insertOrUpdate(CommentEntity comment, EkoCommentFlagEntity commentFlag, String syncState) {
        EkoCommentDao commentDao = UserDatabase.get().commentDao();
        EkoCommentFlagDao commentFlagDao = UserDatabase.get().commentFlagDao();
        commentDao.insert((EkoObject)comment);
        commentFlagDao.insert((EkoObject)commentFlag);
        this.updateSyncState(comment, syncState);
    }

    private final void updateSyncState(CommentEntity comment, String syncState) {
        EkoCommentDao commentDao = UserDatabase.get().commentDao();
        comment.setSyncState(syncState);
        commentDao.update((EkoObject)comment);
    }

    private static final CommentEntity createComment$lambda$1(CommentRepository this$0, CommentEntity $localComment, EkoCommentFlagEntity $commentFlag) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$localComment, (String)"$localComment");
        Intrinsics.checkNotNullParameter((Object)$commentFlag, (String)"$commentFlag");
        this$0.insertOrUpdate($localComment, $commentFlag, AmityComment.State.SYNCING.getStateName());
        return $localComment;
    }

    public static final /* synthetic */ void access$updateSyncState(CommentRepository $this, CommentEntity comment, String syncState) {
        $this.updateSyncState(comment, syncState);
    }
}

