package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.dto.video.StreamBanListDto
import com.amity.socialcloud.sdk.video.domain.stream.StreamIsUnbannedUseCase
import io.reactivex.rxjava3.schedulers.Schedulers

internal class StreamViewerDidUnban : StreamBanEventListener() {

    override fun getEventName(): String {
        return "video-streaming.viewerDidUnban"
    }

    override fun processEvent(dto: StreamBanListDto) {
        dto.list
            .firstOrNull { it.userId == AmityCoreClient.getUserId() }
            ?.streamId
            ?.let(StreamIsUnbannedUseCase()::execute)
            ?.subscribeOn(Schedulers.io())
            ?.subscribe()
    }
}