package com.amity.socialcloud.sdk.api.core.token

import co.amity.rxbridge.toRx2
import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint
import com.amity.socialcloud.sdk.model.core.session.AmityUserToken
import com.amity.socialcloud.sdk.core.domain.token.CreateAmityTokenUseCase
import io.reactivex.Single

class AmityUserTokenManager(
    private val apiKey: String,
    private val endpoint: AmityEndpoint
) {

    fun createUserToken(
        userId: String,
        displayName: String? = null,
        secureToken: String? = null
    ): Single<AmityUserToken> {
        return CreateAmityTokenUseCase().execute(
            endpoint = endpoint,
            apiKey = apiKey,
            userId = userId,
            displayName = displayName,
            secureToken = secureToken
        ).toRx2()
    }

    //future function
    private fun refreshToken() {}

    //future function
    private fun revokeToken() {}

}
