package com.amity.socialcloud.sdk.video.domain.stream

import com.amity.socialcloud.sdk.chat.domain.channel.GetChannelUseCase
import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.social.domain.community.CommunityGetUseCase
import com.amity.socialcloud.sdk.social.domain.post.PostGetUseCase
import com.amity.socialcloud.sdk.video.domain.moderation.StreamModerationGetUseCase

internal class StreamComposerUseCase : ComposerUseCase() {

    fun execute(stream: AmityStream): AmityStream {
        addModeration(stream)
        addCreator(stream)
        addThumbnail(stream)
        addReference(stream)
        addTarget(stream)
        addPost(stream)
        addChannel(stream)
        return stream
    }

    private fun addCreator(stream: AmityStream) {
        stream.user = UserGetUseCase().execute(stream.getCreatorId())
    }

    private fun addThumbnail(stream: AmityStream) {
        stream.thumbnailId?.let {
            stream.thumbnailImage = ImageGetUseCase().execute(it)
        }
    }

    private fun addModeration(stream: AmityStream) {
        stream.moderation = StreamModerationGetUseCase().execute(stream.moderationId)
    }

    private fun addReference(stream: AmityStream) {
        val id = stream.getReferenceId()
        val type = stream.getReferenceType()?.let(AmityStream.ReferenceType::enumOf)
        if (type == AmityStream.ReferenceType.POST && id != null) {
            stream.post = PostGetUseCase().execute(id)
        }
    }

    private fun addTarget(stream: AmityStream) {
        val id = stream.getTargetId()
        val type = stream.getTargetType()?.let(AmityStream.TargetType::enumOf)
        if (type == AmityStream.TargetType.Community && id != null) {
            stream.community = CommunityGetUseCase().execute(id)
        }
    }

    private fun addPost(stream: AmityStream) {
        stream.postId?.let {
            stream.post = PostGetUseCase().execute(it)
        }
    }

    private fun addChannel(stream: AmityStream) {
        stream.channelId?.let {
            stream.channel = GetChannelUseCase().execute(it)
        }
    }

}