package com.amity.socialcloud.sdk.social.data.poll

import com.amity.socialcloud.sdk.model.social.poll.AmityPoll
import com.amity.socialcloud.sdk.model.social.poll.AmityPollAnswer
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.dto.EkoPollQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.PollCreateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.PollUpdateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.PollVoteRequest
import io.reactivex.rxjava3.core.Single

internal class PollRemoteDataStore {

    fun createPoll(
        question: String,
        answers: List<AmityPollAnswer.Data>,
        answerType: String,
        closedIn: Long?,
        title: String?
    ): Single<EkoPollQueryDto> {
        val request = PollCreateRequest(
            question = question,
            answers = PollRepositoryHelper().convertAnswersToJsonArray(answers),
            answerType = answerType,
            closedIn = closedIn,
            title = title
        )
        return AmityHttpClient.get(PollApi::class).flatMap {
            it.createPoll(request)
        }
    }

    fun closePoll(pollId: String): Single<EkoPollQueryDto> {
        val request = PollUpdateRequest(status = AmityPoll.Status.CLOSED.value)
        return AmityHttpClient.get(PollApi::class).flatMap {
            it.updatePoll(pollId, request)
        }
    }

    fun deletePoll(pollId: String): Single<EkoDeletionDto> {
        return AmityHttpClient.get(PollApi::class).flatMap {
            it.deletePoll(pollId)
        }
    }

    fun vote(pollId: String, answerIds: List<String>): Single<EkoPollQueryDto> {
        val request = PollVoteRequest(answerIds)
        return AmityHttpClient.get(PollApi::class).flatMap {
            it.votePoll(pollId, request)
        }
    }
}