package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.MessagePreviewEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MessagePreviewEventBus
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto


internal class MessageDeleted : MessageEventListener() {

    override fun getEventName(): String {
        return "message.deleted"
    }
    
    override fun processEvent(dto: MessageQueryDto) {
        super.processEvent(dto)
        dto.messages.map { message ->
            dto.subChannels.find { it.subChannelId == message.subChannelId }?.let {subChannel ->
                MessagePreviewEvent.MessageDeleted(message,subChannel).let(MessagePreviewEventBus::publish)
            }
        }
    }

}