/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.core.file;

import android.net.Uri;
import com.amity.socialcloud.sdk.core.data.file.FileRepository;
import com.amity.socialcloud.sdk.core.domain.file.FileDeleteUseCase;
import com.amity.socialcloud.sdk.core.domain.file.FileUpdateUseCase;
import com.amity.socialcloud.sdk.core.domain.file.RawFileGetUseCase;
import com.amity.socialcloud.sdk.model.core.content.AmityContentFeedType;
import com.amity.socialcloud.sdk.model.core.file.AmityAudio;
import com.amity.socialcloud.sdk.model.core.file.AmityClip;
import com.amity.socialcloud.sdk.model.core.file.AmityFile;
import com.amity.socialcloud.sdk.model.core.file.AmityImage;
import com.amity.socialcloud.sdk.model.core.file.AmityRawFile;
import com.amity.socialcloud.sdk.model.core.file.AmityVideo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadInfo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\t\u001a\u00020\u0006J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00130\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ*\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00130\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00130\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00130\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00130\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0006J.\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00130\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\"\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00130\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ*\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00130\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006!"}, d2={"Lcom/amity/socialcloud/sdk/api/core/file/AmityFileRepository;", "", "()V", "cancelUpload", "", "uploadId", "", "deleteFile", "Lio/reactivex/rxjava3/core/Completable;", "fileId", "getFile", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/core/file/AmityRawFile;", "getUploadInfo", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadInfo;", "updateAltText", "altText", "uploadAudio", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "Lcom/amity/socialcloud/sdk/model/core/file/AmityAudio;", "uri", "Landroid/net/Uri;", "uploadClip", "Lcom/amity/socialcloud/sdk/model/core/file/AmityClip;", "contentFeedType", "Lcom/amity/socialcloud/sdk/model/core/content/AmityContentFeedType;", "uploadFile", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFile;", "uploadImage", "Lcom/amity/socialcloud/sdk/model/core/file/AmityImage;", "uploadVideo", "Lcom/amity/socialcloud/sdk/model/core/file/AmityVideo;", "amity-sdk_release"})
public final class AmityFileRepository {
    @NotNull
    public final Flowable<AmityUploadResult<AmityFile>> uploadFile(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return this.uploadFile(string, uri);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityFile>> uploadFile(@NotNull String uploadId, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new FileRepository().uploadFile(uploadId, uri);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityImage>> uploadImage(@NotNull Uri uri, @Nullable String altText) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return this.uploadImage(string, uri, altText);
    }

    public static /* synthetic */ Flowable uploadImage$default(AmityFileRepository amityFileRepository, Uri uri, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return amityFileRepository.uploadImage(uri, string);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityImage>> uploadImage(@NotNull String uploadId, @NotNull Uri uri, @Nullable String altText) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new FileRepository().uploadImage(uploadId, uri, altText);
    }

    public static /* synthetic */ Flowable uploadImage$default(AmityFileRepository amityFileRepository, String string, Uri uri, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return amityFileRepository.uploadImage(string, uri, string2);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityAudio>> uploadAudio(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return this.uploadAudio(string, uri);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityAudio>> uploadAudio(@NotNull String uploadId, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new FileRepository().uploadAudio(uploadId, uri);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityVideo>> uploadVideo(@NotNull Uri uri, @NotNull AmityContentFeedType contentFeedType) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)contentFeedType), (String)"contentFeedType");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return this.uploadVideo(string, uri, contentFeedType);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityVideo>> uploadVideo(@NotNull String uploadId, @NotNull Uri uri, @NotNull AmityContentFeedType contentFeedType) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)contentFeedType), (String)"contentFeedType");
        return new FileRepository().uploadVideo(uploadId, uri, contentFeedType);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityClip>> uploadClip(@NotNull Uri uri, @NotNull AmityContentFeedType contentFeedType) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)contentFeedType), (String)"contentFeedType");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return this.uploadClip(string, uri, contentFeedType);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityClip>> uploadClip(@NotNull String uploadId, @NotNull Uri uri, @NotNull AmityContentFeedType contentFeedType) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)contentFeedType), (String)"contentFeedType");
        return new FileRepository().uploadClip(uploadId, uri, contentFeedType);
    }

    public final void cancelUpload(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        new FileRepository().cancelUpload(uploadId);
    }

    @NotNull
    public final Flowable<AmityUploadInfo> getUploadInfo(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        return new FileRepository().getUploadInfo(uploadId);
    }

    @NotNull
    public final Completable deleteFile(@NotNull String fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        return new FileDeleteUseCase().execute(fileId);
    }

    @NotNull
    public final Single<AmityRawFile> getFile(@NotNull String fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        return new RawFileGetUseCase().execute(fileId);
    }

    @NotNull
    public final Completable updateAltText(@NotNull String fileId, @NotNull String altText) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)altText, (String)"altText");
        return new FileUpdateUseCase().execute(fileId, altText);
    }
}

