package com.ekoapp.ekosdk.internal.entity

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "feed")
open class FeedEntity : EkoObject() {

    @PrimaryKey
    var feedId: String = ObjectId.get().toHexString()
    var feedType: String? = null
    var targetId: String? = null
    var targetType: String? = null
    var postCount: Int = 0
    
    override fun getId(): String {
        return feedId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? FeedEntity)?.let { stream ->
            (Objects.equal(feedId, stream.feedId)
                    && Objects.equal(feedType, stream.feedType)
                    && Objects.equal(targetId, stream.targetId)
                    && Objects.equal(targetType, stream.targetType)
                    && Objects.equal(postCount, stream.postCount))
        } ?: kotlin.run { false }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(feedId, feedType, targetId, targetType, postCount)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("feedId", feedId)
            add("feedType", feedType)
            add("targetId", targetId)
            add("targetType", targetType)
            add("postCount", postCount)
        }
        return super.internalToString(toStringHelper)
    }
}