package com.amity.socialcloud.sdk.social.data.post.paging

import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepositoryHelper
import com.ekoapp.ekosdk.internal.keycreator.QueryStreamKeyCreator

class SearchPostKeyCreator(
    private val targetType: String?,
    private val targetId: String?,
    private val hashtags: List<String>,
    private val feedType: AmityFeedType?,
    private val dataTypes: List<AmityPost.DataType>
) : QueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "targetType" to (targetType ?: ""),
            "targetId" to (targetId ?: ""),
            "hashtags" to hashtags,
            "feedType" to (feedType?.apiKey ?: ""),
            "dataTypes" to PostRepositoryHelper.convertPostTypesToString(dataTypes)
        )
    }

    override fun optionalFilterQuery(): String {
        return getConditionStatement()
    }

    private fun getConditionStatement(
    ): String {
        //post is not deleted filter
        val postIsNotDelete = "post.isDeleted = 0"

        //compose all condition
        return postIsNotDelete
    }
}