package com.amity.socialcloud.sdk.api.core.follow.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowRelationship
import com.ekoapp.ekosdk.internal.usecase.user.GetUserFollowingsPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityUserFollowingsQuery private constructor(private val userId: String) {

    fun query(): Flowable<PagingData<AmityFollowRelationship>> {
        return GetUserFollowingsPagingDataUseCase().execute(userId = userId)
    }

    class Builder internal constructor(private val userId: String) {

        fun build(): AmityUserFollowingsQuery {
            return AmityUserFollowingsQuery(userId)
        }
    }

}