package com.amity.socialcloud.sdk.video.data.stream

import androidx.room.Dao
import androidx.room.Query
import androidx.room.Transaction
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Flowable
import org.joda.time.DateTime

@Dao
abstract class EkoStreamDao : EkoObjectDao<EkoStreamEntity>() {
	@Query("SELECT * from stream where streamId = :streamId")
	abstract fun getByIdImpl(streamId: String?): Flowable<EkoStreamEntity>
	fun getById(streamId: String): Flowable<EkoStreamEntity> {
		return getByIdImpl(streamId)
	}

	@Query("SELECT * from stream where streamId = :streamId")
	abstract fun getByIdNowImpl(streamId: String): EkoStreamEntity?

	override fun getByIdNow(streamId: String): EkoStreamEntity? {
		return getByIdNowImpl(streamId)
	}

	@Query("UPDATE stream set isDeleted = 1 where isDeleted = 0")
	abstract fun softDeleteImpl()

	@Query("UPDATE stream set isBanned = :isBanned where streamId = :streamId")
	abstract fun updateStreamIsBannedImpl(streamId: String, isBanned: Int)

	fun updateStreamIsBanned(streamId: String, isBanned: Boolean) {
		updateStreamIsBannedImpl(streamId, if (isBanned) 1 else 0)
	}

	@Transaction
	open fun softDelete() {
		softDeleteImpl()
	}

	@Query("DELETE from stream")
	abstract override fun deleteAll()

	fun getLatestStream(statuses: List<String>): Flowable<EkoStreamEntity> {
		return getLatestStreamImpl(statuses, DateTime.now())
	}

	@Query("SELECT * from stream where status in (:statuses)" +
			" and stream.updatedAt > :now" +
			" order by stream.updatedAt DESC" +
			" limit 1")
	abstract fun getLatestStreamImpl(statuses: List<String>, now: DateTime): Flowable<EkoStreamEntity>

	@Transaction //dummy update
	open fun updateStream(streamId: String) {
		updateStreamImpl(streamId)
	}

	@Query("UPDATE stream set streamId = :streamId where streamId = :streamId")
	abstract fun updateStreamImpl(streamId: String)
}