package com.amity.socialcloud.sdk.video.data.moderation

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.dto.video.StreamModerationDto
import com.amity.socialcloud.sdk.entity.video.stream.StreamModerationEntity


internal class StreamModerationEntityMapper : EntityMapper<StreamModerationDto, StreamModerationEntity>() {

    override fun map(list: List<StreamModerationDto>): List<StreamModerationEntity> {
        return list.map { map(it) }
    }

    private fun map(dto: StreamModerationDto) : StreamModerationEntity {
        return StreamModerationEntity().apply {
            streamId = dto.streamId
            moderationId = dto.moderationId
            flagLabels = dto.flagLabels
            terminateLabels = dto.terminateLabels
            setCreatedAt(dto.createdAt)
            setUpdatedAt(dto.updatedAt)
        }
    }

}