package com.amity.socialcloud.sdk.api.chat.channel.query

import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.common.collect.Sets

class AmityBroadcastChannelQuery private constructor(
    isDeleted: Boolean?,
    filter: AmityChannelFilter,
    includingTags: AmityTags,
    excludingTags: AmityTags
) : AmityChannelQuery(
    isDeleted,
    Sets.newHashSet(AmityChannel.Type.BROADCAST),
    filter,
    includingTags,
    excludingTags
) {

    class Builder internal constructor(){
        private var isDeleted: Boolean? = null
        private var filter = AmityChannelFilter.ALL
        private var includingTags = AmityTags()
        private var excludingTags = AmityTags()

        fun filter(filter: AmityChannelFilter): Builder {
            this.filter = filter
            return this
        }

        fun includingTags(includingTags: AmityTags): Builder {
            this.includingTags = includingTags
            return this
        }

        fun excludingTags(excludingTags: AmityTags): Builder {
            this.excludingTags = excludingTags
            return this
        }

        fun includeDeleted(includeDeleted: Boolean): Builder {
            return apply {
                this.isDeleted = if(includeDeleted) null else false
            }
        }

        fun build(): AmityBroadcastChannelQuery {
            return AmityBroadcastChannelQuery(
                isDeleted,
                filter,
                includingTags,
                excludingTags,
            )
        }

    }

}