package com.amity.socialcloud.sdk.video.domain.stream

import com.amity.socialcloud.sdk.model.video.stream.AmityRecordingData
import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.model.video.stream.AmityWatcherData
import com.amity.socialcloud.sdk.streamapi.PartialStreamData
import io.reactivex.rxjava3.core.Single

internal class GetStreamDataUseCase {

    fun execute(streamId: String): Single<PartialStreamData> {
        FetchStreamUseCase().execute(streamId).subscribe()
        return GetStreamUseCase().execute(streamId)
            .firstOrError()
            .map { stream ->
                val watchingUrls : List<String>? = when (stream.getStatus() ) {
                    AmityStream.Status.LIVE -> {
                        val url = stream.getSerializedWatcherData()?.getUrl(AmityWatcherData.Format.FLV) ?: ""
                        listOf(url)
                    }
                    AmityStream.Status.RECORDED -> {
                        stream.getSerializedRecordings().map { recording ->
                            recording?.getUrl(AmityRecordingData.Format.MP4) ?: ""
                        }.filter { url ->
                            url.isNotEmpty()
                        }
                    }
                    else -> {
                        null
                    }
                }
                PartialStreamData(
                    streamId = streamId,
                    isLive = stream.getStatus() == AmityStream.Status.LIVE,
                    resolution = stream.getResolution() ?: "SD",
                    broadcastingUrl = stream.getBroadcasterData()?.getUrl(),
                    watchingUrls = watchingUrls
                )
            }
    }

}