package com.amity.socialcloud.sdk.social.data.community.membership

import com.amity.socialcloud.sdk.infra.retrofit.request.QueryOptionsRequestParams
import com.amity.socialcloud.sdk.log.AmityLog
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.CommunityListQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.*
import io.reactivex.rxjava3.core.Single

class CommunityMembershipRemoteDataStore {

    fun addUsers(communityId: String, userIds: List<String>): Single<CommunityListQueryDto> {
        val request = CommunityAddUsersRequest(communityId, userIds)
        return AmityHttpClient.get(CommunityMembershipApi::class).flatMap {
            it.addCommunityUsers(communityId, request)
        }
    }

    fun removeUsers(communityId: String, userIds: List<String>): Single<CommunityListQueryDto> {
        val request = CommunityRemoveUsersRequest(communityId, userIds)
        return AmityHttpClient.get(CommunityMembershipApi::class).flatMap {
            it.deleteCommunityUsers(communityId, request)
        }
    }

    fun addRoles(
        communityId: String,
        roles: List<String>,
        userIds: List<String>
    ): Single<CommunityListQueryDto> {
        val request = CommunityAddRolesRequest(communityId, roles, userIds)
        return AmityHttpClient.get(CommunityMembershipApi::class).flatMap {
            it.addCommunityRoles(communityId, request)
        }
    }

    fun removeRoles(
        communityId: String,
        roles: List<String>,
        userIds: List<String>
    ): Single<CommunityListQueryDto> {
        val request = CommunityRemoveRolesRequest(communityId, roles, userIds)
        return AmityHttpClient.get(CommunityMembershipApi::class).flatMap {
            it.deleteCommunityRoles(communityId, request)
        }
    }

    fun banUsers(communityId: String, userIds: List<String>): Single<CommunityListQueryDto> {
        val request = CommunityBanUsersRequest(communityId, userIds)
        return AmityHttpClient.get(CommunityMembershipApi::class).flatMap {
            it.banCommunityUsers(communityId, request)
        }
    }

    fun unbanUsers(communityId: String, userIds: List<String>): Single<CommunityListQueryDto> {
        val request = CommunityUnBanUsersRequest(communityId, userIds)
        return AmityHttpClient.get(CommunityMembershipApi::class).flatMap {
            it.unbanCommunityUsers(communityId, request)
        }
    }

    fun queryCommunityUsers(
        communityId: String,
        memberships: List<String>? = null,
        roles: List<String>? = null,
        sortBy: String? = null,
        isDeleted: Boolean? = null,
        options: QueryOptionsRequestParams
    ): Single<CommunityListQueryDto> {
        return AmityHttpClient.get(CommunityMembershipApi::class).flatMap {
            it.queryCommunityUsers(
                communityId = communityId,
                memberships = memberships,
                isDeleted = isDeleted,
                roles = roles?.takeIf { it.isNotEmpty() } ,
                sortBy = sortBy,
                limit = options.limit,
                token = options.token
            )
        }
    }

    fun searchCommunityUsers(
        communityId: String,
        keyword: String? = null,
        memberships: List<String>? = null,
        roles: List<String>? = null,
        sortBy: String? = null,
        isDeleted: Boolean? = null,
        options: QueryOptionsRequestParams
    ): Single<CommunityListQueryDto> {
        return AmityHttpClient.get(CommunityMembershipApi::class).flatMap {
            it.queryCommunityUsers(
                communityId = communityId,
                keyword = keyword,
                memberships = memberships,
                roles = roles?.takeIf { it.isNotEmpty() },
                sortBy = sortBy,
                isDeleted = isDeleted,
                limit = options.limit,
                token = options.token
            )
        }
    }

}