package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.paging.GlobalFeedKeyCreator
import com.ekoapp.ekosdk.internal.PostEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagingDao

@Dao
internal interface AmityGlobalFeedPagingDao : QueryStreamPagingDao<PostEntity> {

    @RawQuery(observedEntities = [PostEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, PostEntity>

    fun queryGlobalFeedPost(dataTypes: List<AmityPost.DataType>): PagingSource<Int, PostEntity> {
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "post",
                primaryKeyColumnName = "postId",
                queryStreamKeyCreator = GlobalFeedKeyCreator(dataTypes),
                nonce = AmityNonce.GLOBAL_FEED,
                order = AmityPagingDao.Order.ASC
            )
        )
    }
}