package com.amity.socialcloud.sdk.core.data.reaction

import com.amity.socialcloud.sdk.common.EntitySingleMapper
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity

internal class ReactionEntityMapper :
    EntitySingleMapper<EkoReactionAndUserListDto, EkoReactionEntity>() {

    override fun map(dto: EkoReactionAndUserListDto): List<EkoReactionEntity> {
        val reactionEntities = mutableListOf<EkoReactionEntity>()
        dto.reactions.forEach { reaction ->
            reaction.reactors.forEach { reactor ->
                val entity = EkoReactionEntity().apply {
                    this.referenceId = reaction.referenceId
                    this.referenceType = reaction.referenceType
                    this.reactionId = reactor.reactionId
                    this.reactionName = reactor.reactionName
                    this.userId = reactor.userId
                    this.createdAt = reactor.createdAt
                    this.updatedAt = reactor.updatedAt
                }
                reactionEntities.add(entity)
            }
        }
        return reactionEntities
    }
}