package com.amity.socialcloud.sdk.social.domain.storytarget.get

import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository
import com.amity.socialcloud.sdk.social.domain.storytarget.composer.StoryTargetComposerUseCase

internal class GetStoryTargetUseCase {

    fun execute(targetType: AmityStory.TargetType, targetId: String): AmityStoryTarget? {
        return StoryTargetRepository().getStoryTarget(targetType, targetId)?.let {
                StoryTargetComposerUseCase().execute(it)
        }
    }
}