package com.amity.socialcloud.sdk.model.core.presence

import android.os.Parcelable
import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityChannelPresence constructor(
    private val channelId: String,
    private val userPresences: List<AmityUserPresence>,
) : Parcelable {

    fun getChannelId(): String {
        return channelId
    }

    fun getUserPresences(): List<AmityUserPresence> {
        return userPresences
    }

    fun isAnyMemberOnline(): Boolean {
        return userPresences.any {
            it.isOnline() && it.getUserId() != AmityCoreClient.getUserId()
        }
    }
}