package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.session.eventbus.LiveReactionEventBus
import com.amity.socialcloud.sdk.model.core.reaction.live.AmityLiveReaction
import com.ekoapp.ekosdk.internal.api.dto.LiveReactionsDto
import org.joda.time.DateTime

internal class LiveReactionCreated : LiveReactionEventListener() {

    override fun getEventName(): String {
        return "liveReaction.created"
    }

    override fun processEvent(dto: LiveReactionsDto) {
        dto.reactions
            ?.map { reaction ->
                AmityLiveReaction(
                    referenceType = reaction.referenceType ?: "",
                    referenceId = reaction.referenceId ?: "",
                    reactionName = reaction.reactionName ?: "",
                    userId = reaction.userId ?: "",
                    occurredAt = reaction.occurredAt ?: DateTime.now(),
                )
            }
            ?.let { reactions ->
                LiveReactionEventBus.publish(reactions)
            }
    }

}