package com.amity.socialcloud.sdk.core.data.permission

import com.amity.socialcloud.sdk.model.core.permission.AmityPermission
import com.amity.socialcloud.sdk.model.core.permission.AmityPermissions
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.google.common.base.Predicates
import com.google.common.collect.FluentIterable
import io.reactivex.rxjava3.core.Flowable

internal class PermissionRepository {

    fun getGlobalPermission(userId: String): Flowable<List<AmityPermission>> {
        return UserDatabase.get().userDao().getById(userId)
                .map { it.permissions?.let(this::mapToEkoPermissionList) ?: emptyList() }
    }

    fun getChannelPermission(channelId: String, userId: String): Flowable<List<AmityPermission>> {
        return UserDatabase.get().channelMembershipDao().getByChannelIdAndUserId(channelId, userId)
                .map { it.permissions?.let(this::mapToEkoPermissionList) ?: emptyList() }
    }

    fun getCommunityPermission(communityId: String, userId: String): Flowable<List<AmityPermission>> {
        return UserDatabase.get().communityMembershipDao().getById(communityId, userId)
                .map { it.permissions?.let(this::mapToEkoPermissionList) ?: emptyList()  }
    }

    private fun mapToEkoPermissionList(permissions: AmityPermissions): List<AmityPermission> {
        return FluentIterable
                .from(permissions)
                .transform { permission ->
                    if (AmityPermission.values().any { it.value == permission }) {
                        permission?.let { AmityPermission.valueOf(it) }
                    } else null
                }
                .filter(Predicates.notNull())
                .toList()
    }

}