package com.amity.socialcloud.sdk.chat.domain.channel.member

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembership
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository
import com.amity.socialcloud.sdk.model.chat.member.AmityChannelMember
import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class SearchChannelMembershipPagingSourceUseCase {

    fun execute(
        channelId: String,
        memberships: List<AmityChannelMembership>,
        roles: AmityRoles,
        keyword: String,
        isDeleted: Boolean?
    ): Flowable<PagingData<AmityChannelMember>> {
        return ChannelMembershipRepository().searchChannelMembershipPagingData(
            channelId = channelId,
            memberships = memberships.filterNot { it == AmityChannelMembership.MUTED }.map { AmityMembershipType.enumOf(it.apiKey) },
            isMuted = if(memberships.contains(AmityChannelMembership.MUTED)) true else null,
            roles = roles,
            keyword = keyword,
            isDeleted = isDeleted
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { channelMember ->
                ChannelMemberComposerUseCase().execute(channelMember)
            }
        }
    }

}