package com.amity.socialcloud.sdk.chat.data.subchannel

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.subchannel.AmitySubChannel
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.internal.SubChannelEntity

internal class SubChannelModelMapper : ModelMapper<SubChannelEntity, AmitySubChannel>() {

    override fun map(entity: SubChannelEntity): AmitySubChannel {
        return entity.run {
            AmitySubChannel(
                subChannelId = subChannelId,
                channelId = channelId,
                channelType = AmityChannel.Type.enumOf(channelType),
                channelPublicId = channelPublicId,
                displayName = name,
                messageCount = messageCount,
                isDeleted = isDeleted,
                latestMessageId = latestMessageId,
                lastActivity = lastActivity,
                creatorId = creatorId,
                creatorPublicId = creatorPublicId,
                creator = getUser(creatorPublicId),
                editedAt = editedAt,
                createdAt = createdAt,
                updatedAt = updatedAt,
                path = path,
                messagePreviewId = messagePreviewId,
            )
        }
    }

    private fun getUser(userId: String): AmityUser? {
        return UserGetUseCase().execute(userId)
    }
}
