package com.amity.socialcloud.sdk.social.domain.category

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.model.social.category.AmityCommunityCategory

internal class CategoryComposerUseCase : ComposerUseCase() {

    fun execute(category: AmityCommunityCategory): AmityCommunityCategory {
        category.avatarFileId
            ?.let { ImageGetUseCase().execute(it) }
            ?.let { category.avatar = it }

        return category
    }
}